#include "IPHeader.h"
#include <iomanip>

IPHeader::IPHeader(u_int _dest, u_int _src, u_char _protocol, u_short _data_length) {
  memset(&data, 0, IP_HEADER_SIZE);
  data.version_ihl = 0x45;
  data.tos = 0;
  data.total_length = _data_length + IP_HEADER_SIZE;
  data.identification = 0;
  data.frag_info = 0x4000;
  data.ttl = 64;
  data.protocol = _protocol;
  data.source = _src;
  data.dest = _dest;
  data2network();
  comp_checksum = compute_checksum();
  data2host();
  data.checksum = comp_checksum;
}

IPHeader::IPHeader(const u_char *_data) {
  memcpy(&data, _data, IP_HEADER_SIZE);
  u_short rec_checksum = data.checksum;
  data.checksum = 0;
  comp_checksum = compute_checksum();
  data.checksum = rec_checksum;
  data2host();
}

void IPHeader::dump() {
  cout << "IP Header:\n";
  cout << "  Length: " << (int)(this->total_length() - (this->ihl() << 2)) << "B data + " << (int)(this->ihl() << 2) << "B Header" << endl;
  cout << "  Type of service: 0x" << setbase(16) << setfill('0') << setw(2) << (int) u_int(this->tos()) << setbase(10) << endl;
  cout << "  Identification: " << (int)this->identification() << endl;
  cout << "  Fragmentation flags: 0x" << setbase(16) << setw(2) << (int) (this->flags()) << setbase(10) << setfill(' ') << endl;
  cout << "  Fragmentation offset: " << (int)(this->frag_offset()) << endl;
  cout << "  TTL: " << (int)(this->ttl()) << endl;
  cout << "  Protocol: " << (int)(this->protocol()) << endl;
  cout << "  Checksum: 0x" << setbase(16) << setfill('0') << setw(4) << data.checksum << "(0x" << setw(4) << comp_checksum << " computed)" << setfill(' ') << setbase(10) << endl;
  cout << "  Source address: ";
  printIPAddress(this->source());
  cout <<  endl << "  Destination address: ";
  printIPAddress(this->dest());
  cout << endl << endl << endl;
}

u_short IPHeader::compute_checksum() {
  u_long sum = 0;
  const u_short *p = (const u_short *)&data;
  for (int i = 0; i < IP_HEADER_SIZE / 2; i++) sum += (u_long)ntohs(~*p++);
  return ((u_short)sum) + ((u_short)(sum >> 16));
}

void IPHeader::setMem(u_char *to_data) {
  data2network();
  memcpy(to_data, &data, sizeof(data));
  data2host();
}

u_char IPHeader::version() { 
  return data.version_ihl >> 4;
}

u_char IPHeader::ihl() { 
  return data.version_ihl & 0x0f;
}

u_char IPHeader::tos() { 
  return data.tos; 
}

u_short IPHeader::total_length() { 
  return data.total_length; 
}

u_short IPHeader::identification() { 
  return data.identification;
}

u_char IPHeader::flags() { 
  return data.frag_info >> 13;
}

u_short IPHeader::frag_offset() { 
  return data.frag_info & 0x1fff; 
}

u_char IPHeader::ttl() { 
  return data.ttl; 
}

u_char IPHeader::protocol() { 
  return data.protocol; 
}

u_short IPHeader::checksum() { 
  return data.checksum; 
}

u_int IPHeader::source() { 
  return data.source; 
}

u_int IPHeader::dest() { 
  return data.dest; 
}

void IPHeader::data2host(void) {
  data.total_length = ntohs(data.total_length);
  data.identification = ntohs(data.identification);
  data.frag_info = ntohs(data.frag_info);
  data.checksum = ntohs(data.checksum);
  data.source = ntohl(data.source);
  data.dest = ntohl(data.dest);
}
void IPHeader::data2network(void) {
  data.total_length = htons(data.total_length);
  data.identification = htons(data.identification);
  data.frag_info = htons(data.frag_info);
  data.checksum = htons(data.checksum);
  data.source = htonl(data.source);
  data.dest = htonl(data.dest);
}
